#!/usr/local/bin/perl

$LOCKDIR = './lock/';
$RESULT_FILE = "./data/score.txt";

&Main;

sub Main{
	&GetFormData;

	$DATA_FILE = $RESULT_FILE;
	&Lock;
	open( IN, $DATA_FILE );
	@logs = <IN>;
	close( IN );
	$gl_nowtime = time;
	$date = &GetDate( $gl_nowtime );
	$title = $in{ title };
	open( OUT, ">$DATA_FILE" );
	print OUT "$gl_nowtime<>$date<>$cookie{login_id}<>$nickname<>$in{file}<>$title<>$in{msg}\n";
	print OUT @logs;
	close( OUT );
	&UnLock;

	print "Content-type: text/html\n\n";
	print "data=ok";
}

#-----------------------------------------------------#
#  t
#-----------------------------------------------------#
sub GetDate{
	local($sec,$min,$hour,$day,$mon,$year,$dateno)=localtime($_[0]);
	local(@dates)=('','','','','','','y');
	$year += 1900; $mon++; $min = sprintf("%02d",$min);
	$hour = sprintf("%02d",$hour);
	if($USEHAND){
		$date = "$mon/$day($dates[$dateno]) $hour:$min";
	}else{
		$date = "$year/$mon/$day($dates[$dateno]) $hour:$min";
	}
	return $date;
}

#-----------------------------------------------------#
#  tH[f[^擾
#-----------------------------------------------------#
sub GetFormData{
	local($buffer,@pairs);
	if($ENV{REQUEST_METHOD} eq 'POST' ){
		read(STDIN,$buffer,$ENV{CONTENT_LENGTH});
	}else{$buffer = $ENV{QUERY_STRING};}
	@pairs = split(/&/,$buffer);

	foreach(@pairs){
		local($key,$value) = split(/=/,$_);
		$value =~ tr/+/ /;
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
		$value =~ s/&/&amp;/g;
		$value =~ s/"/&quot;/g;
		$value =~ s/</&lt;/g;
		$value =~ s/>/&gt;/g;
		$value =~ s/\r\n/\n/g;
		$value =~ s/\n/<br>/g;
		$in{$key} = $value;
	}
}


#-----------------------------------------------------#
#  NbL[̎擾
#-----------------------------------------------------#
sub GetCookie{
	my $name = $_[0];
	local($key,$val);
	@cookies = split(/; /,$ENV{HTTP_COOKIE});
	foreach(@cookies){
		($key,$val) = split(/=/,$_);
		if($key eq $name){
			@cookies = split(/,/,$val);
			foreach(@cookies){
				($key,$val) = split(/:/,$_);
				$val =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("C", hex($1))/eg;
				$cookie{$key} = $val;
			}
			last;
		}
	}
}

#-----------------------------------------------------#
#  bN
#-----------------------------------------------------#
sub Lock{
	$flag = 0;
	for( $i = 0; $i <= 10; $i++ ){
		if( mkdir( $LOCKDIR, 0755 ) ){
			$flag = 1;
			last;
		}else{
			# fbhbNɂȂĂȂH
			($mtime) = (stat( "./lock" ))[9];
			if( $mtime + 120 < time ){

				#bN
				rmdir( $LOCKDIR );

				#ĂуbN
				mkdir( $LOCKDIR, 0755 );
				$flag = 1;
				last;
			}
			sleep( 1 );
		}
	}
	if( !$flag ){
		&LockError("ANZXN܂B");
	}
}

#bNpG[
sub LockError{
	print "$_[0]<br>";
	print "<a href=\"$THISURL\">߂</a><br>\n";
	&Foot;
	exit;
}

#-----------------------------------------------------#
#  AbN
#-----------------------------------------------------#
sub UnLock{
	rmdir($LOCKDIR);
}

#G[
sub Error{
	print "<p>@_</p>\n";;
	&Foot;
	exit;
}
