#!/usr/local/bin/perl

#{p
$THISURL = "lookscore.cgi";
$LOCKDIR = './lock/';
$RESULT_FILE = "./data/score.txt";
$START_FILE = "./data/start.txt";

&Main;

sub Main{
	&GetFormData;

	&Head;
	&LookScore;
}

#-----------------------------------------------------#
#  wb_
#-----------------------------------------------------#
sub Head{
	print << "HEAD";
Content-type: text/html

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=shift_jis">
<title>Wv</title>
</head>
<body>
<a href="../../">Home</a> <a href="./regist.cgi">XV</a>
HEAD
}

sub Foot{
	print "</body>\n</html>\n";
}

#-----------------------------------------------------#
#  {
#-----------------------------------------------------#
sub LookScore{

	print "<h2>NAl</h2>\n";

	if( $in{ mode} == 0 ){
		$DATA_FILE = $START_FILE;
	}else{
		$DATA_FILE = $RESULT_FILE;
	}

	open( IN, $DATA_FILE );
	@dats = <IN>;
	close( IN );

	foreach( @dats ){
		my($time,$date,$id,$nickname,$file,$title,$msg) = split(/<>/ ,$_ );

		print "$nickname <small>($date) <a href=\"./?file=$file&title=$title\">$title</a></small><br>\n";
		if( $msg ){
			print "<span style=\"margin-left: 2em;\">$msg</span><br>\n";
		}
		print "<hr>\n";
	}
}

#-----------------------------------------------------#
#  Wv\
#-----------------------------------------------------#
sub LookResult{
	print "<h2>Wv</h2>\n";

	open( IN, $RESULT_FILE ) or &Error( $RESULT_FILE );
	@dats = <IN>;
	close( IN );

	foreach( @dats ){
		($id,$nickname,$score) = split(/<>/, $_ );
		print "$nickname($id) &gt; $score<hr>\n";
	}
}

#-----------------------------------------------------#
#  TOP
#-----------------------------------------------------#
sub Top{
	print "<h2>Wv</h2>\n";

	open( IN, $RESULT_FILE ) or &Error( $RESULT_FILE );
	@dats = <IN>;
	close( IN );

	foreach( @dats ){
		($id,$nickname,$score) = split(/<>/, $_ );
		print "$nickname($id) &gt; $score<hr>\n";
	}
}

#-----------------------------------------------------#
#  tH[f[^擾
#-----------------------------------------------------#
sub GetFormData{
	local($buffer,@pairs);
	if($ENV{REQUEST_METHOD} eq 'POST' ){
		read(STDIN,$buffer,$ENV{CONTENT_LENGTH});
	}else{$buffer = $ENV{QUERY_STRING};}
	@pairs = split(/&/,$buffer);

	foreach(@pairs){
		local($key,$value) = split(/=/,$_);
		$value =~ tr/+/ /;
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
		$value =~ s/&/&amp;/g;
		$value =~ s/"/&quot;/g;
		$value =~ s/</&lt;/g;
		$value =~ s/>/&gt;/g;
		$value =~ s/\r\n/\n/g;
		$value =~ s/\n/<br>/g;
		$in{$key} = $value;
	}
}


#-----------------------------------------------------#
#  NbL[̎擾
#-----------------------------------------------------#
sub GetCookie{
	my $name = $_[0];
	local($key,$val);
	@cookies = split(/; /,$ENV{HTTP_COOKIE});
	foreach(@cookies){
		($key,$val) = split(/=/,$_);
		if($key eq $name){
			@cookies = split(/,/,$val);
			foreach(@cookies){
				($key,$val) = split(/:/,$_);
				$val =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("C", hex($1))/eg;
				$cookie{$key} = $val;
			}
			last;
		}
	}
}

#-----------------------------------------------------#
#  bN
#-----------------------------------------------------#
sub Lock{
	$flag = 0;
	for( $i = 0; $i <= 10; $i++ ){
		if( mkdir( $LOCKDIR, 0755 ) ){
			$flag = 1;
			last;
		}else{
			# fbhbNɂȂĂȂH
			($mtime) = (stat( "./lock" ))[9];
			if( $mtime + 120 < time ){

				#bN
				rmdir( $LOCKDIR );

				#ĂуbN
				mkdir( $LOCKDIR, 0755 );
				$flag = 1;
				last;
			}
			sleep( 1 );
		}
	}
	if( !$flag ){
		&LockError("ANZXN܂B");
	}
}

#bNpG[
sub LockError{
	print "$_[0]<br>";
	print "<a href=\"$THISURL\">߂</a><br>\n";
	&Foot;
	exit;
}

#-----------------------------------------------------#
#  AbN
#-----------------------------------------------------#
sub UnLock{
	rmdir($LOCKDIR);
}

#G[
sub Error{
	print "<p>@_</p>\n";;
	&Foot;
	exit;
}
